/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.render;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.framework.objects.gradient.Gradient;
import Krasnodar.rockstarnew.framework.shader.GlProgram;
import Krasnodar.rockstarnew.framework.shader.impl.BlurProgram;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.interfaces.IWindow;
import Krasnodar.rockstarnew.utility.math.MathUtility;
import Krasnodar.rockstarnew.utility.render.ColorUtility;
import Krasnodar.rockstarnew.utility.render.CustomRenderTarget;
import Krasnodar.rockstarnew.utility.render.HookLimiter;
import Krasnodar.rockstarnew.utility.render.batching.Batching;
import Krasnodar.rockstarnew.utility.render.batching.impl.IconBatching;
import Krasnodar.rockstarnew.utility.render.batching.impl.RectBatching;
import Krasnodar.rockstarnew.utility.render.batching.impl.RoundedRectBatching;
import Krasnodar.rockstarnew.utility.render.batching.impl.SquircleBatching;
import Krasnodar.rockstarnew.utility.render.obj.CustomSprite;
import Krasnodar.rockstarnew.utility.render.penis.PenisSprite;
import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Generated;
import net.minecraft.class_10042;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1309;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_742;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import ru.kotopushka.compiler.sdk.annotations.Initialization;

public final class DrawUtility
implements IMinecraft,
IWindow {
    public static final float DEFAULT_SMOOTHNESS = 0.5f;
    public static final HookLimiter limiter = new HookLimiter(true);
    public static GlProgram rectangleProgram;
    private static GlProgram squircleProgram;
    private static GlProgram roundedTextureProgram;
    private static GlProgram squircleTextureProgram;
    private static GlProgram borderProgram;
    private static GlProgram loadingProgram;
    private static GlProgram glassProgram;
    private static GlProgram gradientRectangleProgram;
    public static BlurProgram blurProgram;
    private static final CustomRenderTarget buffer;

    @Initialization
    public static void initializeShaders() {
        rectangleProgram = new GlProgram(Rockstar.id("rectangle/data"), class_290.field_1576);
        squircleProgram = new GlProgram(Rockstar.id("squircle/data"), class_290.field_1576);
        squircleTextureProgram = new GlProgram(Rockstar.id("squircle_texture/data"), class_290.field_1575);
        roundedTextureProgram = new GlProgram(Rockstar.id("texture/data"), class_290.field_1575);
        borderProgram = new GlProgram(Rockstar.id("border/data"), class_290.field_1576);
        loadingProgram = new GlProgram(Rockstar.id("loading/data"), class_290.field_1576);
        glassProgram = new GlProgram(Rockstar.id("liquidglass/data"), class_290.field_1575);
        gradientRectangleProgram = new GlProgram(Rockstar.id("gradient_rectangle/data"), class_290.field_1576);
        blurProgram = new BlurProgram();
        blurProgram.initShaders();
    }

    public static void updateBuffer() {
        buffer.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        buffer.setup();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        mc.method_1522().method_35610();
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (int)mc.method_1522().method_30277());
        DrawUtility.drawQuad(0.0f, 0.0f, mw.method_4486(), mw.method_4502(), true);
        mc.method_1522().method_1242();
        RenderSystem.disableBlend();
        mc.method_1522().method_1235(true);
        buffer.stop();
    }

    private static void drawQuad(float x, float y, float width, float height, boolean flip) {
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        int color = -1;
        float vTop = flip ? 0.0f : 1.0f;
        float vBottom = flip ? 1.0f : 0.0f;
        builder.method_22912(x, y, 0.0f).method_22913(0.0f, vBottom).method_39415(-1);
        builder.method_22912(x, y + height, 0.0f).method_22913(0.0f, vTop).method_39415(-1);
        builder.method_22912(x + width, y + height, 0.0f).method_22913(1.0f, vTop).method_39415(-1);
        builder.method_22912(x + width, y, 0.0f).method_22913(1.0f, vBottom).method_39415(-1);
        class_286.method_43433((class_9801)builder.method_60800());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(class_4587 matrices, class_241 from, class_241 to, ColorRGBA color) {
        matrices.method_22903();
        try {
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            RenderSystem.lineWidth((float)1.0f);
            DrawUtility.drawSetup();
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
            builder.method_22918(matrix4f, from.field_1343, from.field_1342, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, to.field_1343, to.field_1342, 0.0f).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
        }
        finally {
            RenderSystem.disableBlend();
            RenderSystem.lineWidth((float)1.0f);
            matrices.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawBezier(class_4587 matrices, class_241 p0, class_241 p1, class_241 p2, class_241 p3, ColorRGBA color, int resolution) {
        matrices.method_22903();
        try {
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            RenderSystem.lineWidth((float)1.0f);
            DrawUtility.drawSetup();
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29345, class_290.field_1576);
            for (int i = 0; i <= resolution; ++i) {
                float t = (float)i / (float)resolution;
                float x = (float)MathUtility.cubicBezier(t, p0.field_1343, p1.field_1343, p2.field_1343, p3.field_1343);
                float y = (float)MathUtility.cubicBezier(t, p0.field_1342, p1.field_1342, p2.field_1342, p3.field_1342);
                builder.method_22918(matrix4f, x, y, 0.0f).method_39415(color.getRGB());
            }
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
        }
        finally {
            RenderSystem.disableBlend();
            RenderSystem.lineWidth((float)1.0f);
            matrices.method_22909();
        }
    }

    private static float cubicBezier(float t, float p0, float p1, float p2, float p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        return uu * u * p0 + 3.0f * uu * t * p1 + 3.0f * u * tt * p2 + tt * t * p3;
    }

    public static void drawRect(class_4587 matrices, float x, float y, float width, float height, ColorRGBA color) {
        Batching batching = Batching.getActive();
        if (batching instanceof RectBatching) {
            RectBatching batching2 = (RectBatching)batching;
            class_287 builder = batching2.getBuilder();
            Matrix4f matrix4f = batching2.getMatrices().method_23760().method_23761();
            builder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x, y, 0.0f).method_39415(color.getRGB());
        } else {
            matrices.method_22903();
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            DrawUtility.drawSetup();
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            builder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x, y, 0.0f).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            matrices.method_22909();
        }
    }

    public static void drawSquircle(class_4587 matrices, float x, float y, float width, float height, float squirt, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f m = matrices.method_23760().method_23761();
        float smoothness = 0.5f;
        Batching batching = Batching.getActive();
        if (batching instanceof SquircleBatching) {
            SquircleBatching sb = (SquircleBatching)batching;
            sb.add(m, x, y, width, height, borderRadius.topLeftRadius() * squirt / 2.0f, borderRadius.bottomLeftRadius() * squirt / 2.0f, borderRadius.topRightRadius() * squirt / 2.0f, borderRadius.bottomRightRadius() * squirt / 2.0f, color.getRGB());
            matrices.method_22909();
        } else {
            squircleProgram.use();
            squircleProgram.findUniform("Size").method_1255(width, height);
            squircleProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius() * squirt / 2.0f, borderRadius.bottomLeftRadius() * squirt / 2.0f, borderRadius.topRightRadius() * squirt / 2.0f, borderRadius.bottomRightRadius() * squirt / 2.0f);
            squircleProgram.findUniform("Smoothness").method_1251(smoothness);
            squircleProgram.findUniform("CornerSmoothness").method_1251(squirt);
            DrawUtility.drawSetup();
            float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
            float verticalPadding = smoothness / 2.0f + smoothness;
            float ax = x - horizontalPadding / 2.0f;
            float ay = y - verticalPadding / 2.0f;
            float aw = width + horizontalPadding;
            float ah = height + verticalPadding;
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            builder.method_22918(m, ax, ay, 0.0f).method_39415(color.getRGB());
            builder.method_22918(m, ax, ay + ah, 0.0f).method_39415(color.getRGB());
            builder.method_22918(m, ax + aw, ay + ah, 0.0f).method_39415(color.getRGB());
            builder.method_22918(m, ax + aw, ay, 0.0f).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            matrices.method_22909();
        }
    }

    public static void drawLoadingRect(class_4587 matrices, float x, float y, float width, float height, float progress, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float smoothness = 0.5f;
        loadingProgram.use();
        loadingProgram.findUniform("Size").method_1255(width, height);
        loadingProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
        loadingProgram.findUniform("Smoothness").method_1251(smoothness);
        loadingProgram.findUniform("Progress").method_1251(progress);
        loadingProgram.findUniform("StripeWidth").method_1251(0.0f);
        loadingProgram.findUniform("Fade").method_1251(0.5f);
        DrawUtility.drawSetup();
        float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
        float verticalPadding = smoothness / 2.0f + smoothness;
        float adjustedX = x - horizontalPadding / 2.0f;
        float adjustedY = y - verticalPadding / 2.0f;
        float adjustedWidth = width + horizontalPadding;
        float adjustedHeight = height + verticalPadding;
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_39415(color.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
        DrawUtility.drawEnd();
        matrices.method_22909();
    }

    public static void drawLiquidGlass(class_4587 matrices, float x, float y, float width, float height, BorderRadius borderRadius, ColorRGBA color, float globalAlpha, float fresnelPower, ColorRGBA fresnelColor, float baseAlpha, boolean fresnelInvert, float fresnelMix, float distortStrength, float squirt, boolean clean) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        DrawUtility.drawSetup();
        RenderSystem.disableCull();
        RenderSystem.setShaderTexture((int)0, (int)(clean ? mc.method_1522().method_30277() : BlurProgram.getTexture()));
        glassProgram.use();
        glassProgram.findUniform("GlobalAlpha").method_1251(globalAlpha);
        glassProgram.findUniform("Size").method_1255(width, height);
        glassProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
        glassProgram.findUniform("Smoothness").method_1251(0.5f);
        glassProgram.findUniform("FresnelPower").method_1251(fresnelPower);
        glassProgram.findUniform("FresnelColor").method_1253(ColorUtility.getRGBf(fresnelColor.getRGB()));
        glassProgram.findUniform("FresnelAlpha").method_1251(ColorUtility.alphaf(fresnelColor.getRGB()));
        glassProgram.findUniform("BaseAlpha").method_1251(baseAlpha);
        glassProgram.findUniform("FresnelInvert").method_35649(fresnelInvert ? 1 : 0);
        glassProgram.findUniform("FresnelMix").method_1251(fresnelMix);
        glassProgram.findUniform("DistortStrength").method_1251(distortStrength);
        glassProgram.findUniform("CornerSmoothness").method_1251(squirt);
        int screenWidth = mw.method_4486();
        int screenHeight = mw.method_4502();
        float u = x / (float)screenWidth;
        float v = ((float)screenHeight - y - height) / (float)screenHeight;
        float texWidth = width / (float)screenWidth;
        float texHeight = height / (float)screenHeight;
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(matrix, x, y, 0.0f).method_22913(u, v + texHeight).method_39415(color.getRGB());
        builder.method_22918(matrix, x, y + height, 0.0f).method_22913(u, v).method_39415(color.getRGB());
        builder.method_22918(matrix, x + width, y + height, 0.0f).method_22913(u + texWidth, v).method_39415(color.getRGB());
        builder.method_22918(matrix, x + width, y, 0.0f).method_22913(u + texWidth, v + texHeight).method_39415(color.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.enableCull();
        DrawUtility.drawEnd();
    }

    public static void drawRoundedRect(class_4587 matrices, float x, float y, float width, float height, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f m = matrices.method_23760().method_23761();
        float smoothness = 0.5f;
        Batching batching = Batching.getActive();
        if (batching instanceof RoundedRectBatching) {
            RoundedRectBatching rb = (RoundedRectBatching)batching;
            rb.add(m, x, y, width, height, borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius(), color.getRGB());
            matrices.method_22909();
        } else {
            rectangleProgram.use();
            rectangleProgram.findUniform("Size").method_1255(width, height);
            rectangleProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
            rectangleProgram.findUniform("Smoothness").method_1251(smoothness);
            DrawUtility.drawSetup();
            float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
            float verticalPadding = smoothness / 2.0f + smoothness;
            float ax = x - horizontalPadding / 2.0f;
            float ay = y - verticalPadding / 2.0f;
            float aw = width + horizontalPadding;
            float ah = height + verticalPadding;
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            builder.method_22918(m, ax, ay, 0.0f).method_39415(color.getRGB());
            builder.method_22918(m, ax, ay + ah, 0.0f).method_39415(color.getRGB());
            builder.method_22918(m, ax + aw, ay + ah, 0.0f).method_39415(color.getRGB());
            builder.method_22918(m, ax + aw, ay, 0.0f).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            matrices.method_22909();
        }
    }

    public static void drawRoundedRect(class_4587 matrices, float x, float y, float width, float height, BorderRadius borderRadius, ColorRGBA color1, ColorRGBA color2, ColorRGBA color3, ColorRGBA color4) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float smoothness = 0.5f;
        gradientRectangleProgram.use();
        gradientRectangleProgram.findUniform("Size").method_1255(width, height);
        gradientRectangleProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
        gradientRectangleProgram.findUniform("Smoothness").method_1251(smoothness);
        gradientRectangleProgram.findUniform("TopLeftColor").method_35657(color1.getRed() / 255.0f, color1.getGreen() / 255.0f, color1.getBlue() / 255.0f, color1.getAlpha() / 255.0f);
        gradientRectangleProgram.findUniform("BottomLeftColor").method_35657(color2.getRed() / 255.0f, color2.getGreen() / 255.0f, color2.getBlue() / 255.0f, color2.getAlpha() / 255.0f);
        gradientRectangleProgram.findUniform("BottomRightColor").method_35657(color3.getRed() / 255.0f, color3.getGreen() / 255.0f, color3.getBlue() / 255.0f, color3.getAlpha() / 255.0f);
        gradientRectangleProgram.findUniform("TopRightColor").method_35657(color4.getRed() / 255.0f, color4.getGreen() / 255.0f, color4.getBlue() / 255.0f, color4.getAlpha() / 255.0f);
        DrawUtility.drawSetup();
        float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
        float verticalPadding = smoothness / 2.0f + smoothness;
        float adjustedX = x - horizontalPadding / 2.0f;
        float adjustedY = y - verticalPadding / 2.0f;
        float adjustedWidth = width + horizontalPadding;
        float adjustedHeight = height + verticalPadding;
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_39415(color1.getRGB());
        builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_39415(color2.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_39415(color3.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_39415(color4.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
        DrawUtility.drawEnd();
        matrices.method_22909();
    }

    public static void drawRoundedRect(class_4587 matrices, float x, float y, float width, float height, BorderRadius borderRadius, Gradient gradient) {
        DrawUtility.drawRoundedRect(matrices, x, y, width, height, borderRadius, gradient.getTopLeftColor(), gradient.getBottomLeftColor(), gradient.getBottomRightColor(), gradient.getTopRightColor());
    }

    public static void drawRoundedBorder(class_4587 matrices, float x, float y, float width, float height, float borderThickness, BorderRadius borderRadius, ColorRGBA borderColor) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float internalSmoothness = 0.5f;
        float externalSmoothness = 1.0f;
        borderProgram.use();
        borderProgram.findUniform("Size").method_1255(width, height);
        borderProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
        borderProgram.findUniform("Smoothness").method_1255(internalSmoothness, externalSmoothness);
        borderProgram.findUniform("Thickness").method_1251(borderThickness);
        DrawUtility.drawSetup();
        float horizontalPadding = -externalSmoothness / 2.0f + externalSmoothness * 2.0f;
        float verticalPadding = externalSmoothness / 2.0f + externalSmoothness;
        float adjustedX = x - horizontalPadding / 2.0f;
        float adjustedY = y - verticalPadding / 2.0f;
        float adjustedWidth = width + horizontalPadding;
        float adjustedHeight = height + verticalPadding;
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_39415(borderColor.getRGB());
        builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_39415(borderColor.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_39415(borderColor.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_39415(borderColor.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
        DrawUtility.drawEnd();
        matrices.method_22909();
    }

    public static void drawTexture(class_4587 matrices, class_2960 identifier, float x, float y, float width, float height, ColorRGBA textureColor) {
        Batching batching = Batching.getActive();
        if (batching instanceof IconBatching) {
            IconBatching batching2 = (IconBatching)batching;
            class_287 builder = batching2.getBuilder();
            Matrix4f matrix4f = batching2.getMatrices().method_23760().method_23761();
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            builder.method_22918(matrix4f, x, y, 0.0f).method_22913(0.0f, 0.0f).method_39415(textureColor.getRGB());
            builder.method_22918(matrix4f, x, y + height, 0.0f).method_22913(0.0f, 1.0f).method_39415(textureColor.getRGB());
            builder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22913(1.0f, 1.0f).method_39415(textureColor.getRGB());
            builder.method_22918(matrix4f, x + width, y, 0.0f).method_22913(1.0f, 0.0f).method_39415(textureColor.getRGB());
        } else {
            matrices.method_22903();
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            DrawUtility.drawSetup();
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            builder.method_22918(matrix4f, x, y, 0.0f).method_22913(0.0f, 0.0f).method_39415(textureColor.getRGB());
            builder.method_22918(matrix4f, x, y + height, 0.0f).method_22913(0.0f, 1.0f).method_39415(textureColor.getRGB());
            builder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22913(1.0f, 1.0f).method_39415(textureColor.getRGB());
            builder.method_22918(matrix4f, x + width, y, 0.0f).method_22913(1.0f, 0.0f).method_39415(textureColor.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            RenderSystem.setShaderTexture((int)0, (int)0);
            matrices.method_22909();
        }
    }

    public static void drawTexture(class_4587 matrices, class_2960 identifier, float x, float y, float width, float height, float u1, float u2, float v1, float v2, ColorRGBA clor) {
        Batching batching = Batching.getActive();
        if (batching instanceof IconBatching) {
            IconBatching batching2 = (IconBatching)batching;
            class_287 builder = batching2.getBuilder();
            Matrix4f matrix4f = batching2.getMatrices().method_23760().method_23761();
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            int color = clor.getRGB();
            float x2 = x + width;
            float y2 = y + height;
            builder.method_22918(matrix4f, x, y, 0.0f).method_22913(u1, v1).method_39415(color);
            builder.method_22918(matrix4f, x, y2, 0.0f).method_22913(u1, v2).method_39415(color);
            builder.method_22918(matrix4f, x2, y2, 0.0f).method_22913(u2, v2).method_39415(color);
            builder.method_22918(matrix4f, x2, y, 0.0f).method_22913(u2, v1).method_39415(color);
        } else {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matrices.method_22903();
            int color = clor.getRGB();
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            float x2 = x + width;
            float y2 = y + height;
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            builder.method_22918(matrix4f, x, y, 0.0f).method_22913(u1, v1).method_39415(color);
            builder.method_22918(matrix4f, x, y2, 0.0f).method_22913(u1, v2).method_39415(color);
            builder.method_22918(matrix4f, x2, y2, 0.0f).method_22913(u2, v2).method_39415(color);
            builder.method_22918(matrix4f, x2, y, 0.0f).method_22913(u2, v1).method_39415(color);
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            RenderSystem.setShaderTexture((int)0, (int)0);
            matrices.method_22909();
            RenderSystem.disableBlend();
        }
    }

    public static void drawAnimationSprite(class_4587 matrices, PenisSprite sprite, float x, float y, float width, float height, ColorRGBA color) {
        if (sprite != null) {
            DrawUtility.drawTexture(matrices, sprite.texture(), x, y, width, height, sprite.u1(), sprite.u2(), sprite.v1(), sprite.v2(), color);
        }
    }

    public static void drawSprite(class_4587 matrices, CustomSprite sprite, float x, float y, float width, float height, ColorRGBA color) {
        DrawUtility.drawTexture(matrices, Rockstar.id(sprite.getTexture().getTexture()), x, y, width, height, sprite.x / sprite.getTexture().getWidth(), (sprite.x + sprite.getTexture().getStep()) / sprite.getTexture().getWidth(), 0.0f, 1.0f, color);
    }

    public static void drawRoundedTexture(class_4587 matrices, class_2960 identifier, float x, float y, float width, float height, BorderRadius borderRadius) {
        DrawUtility.drawRoundedTexture(matrices, identifier, x, y, width, height, borderRadius, Colors.WHITE);
    }

    public static void drawRoundedTexture(class_4587 matrices, class_2960 identifier, float x, float y, float width, float height, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float smoothness = 0.5f;
        roundedTextureProgram.use();
        RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
        roundedTextureProgram.findUniform("Size").method_1255(width, height);
        roundedTextureProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
        roundedTextureProgram.findUniform("Smoothness").method_1251(smoothness);
        DrawUtility.drawSetup();
        float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
        float verticalPadding = smoothness / 2.0f + smoothness;
        float adjustedX = x - horizontalPadding / 2.0f;
        float adjustedY = y - verticalPadding / 2.0f;
        float adjustedWidth = width + horizontalPadding;
        float adjustedHeight = height + verticalPadding;
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_22913(0.0f, 0.0f).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_22913(0.0f, 1.0f).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_22913(1.0f, 1.0f).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_22913(1.0f, 0.0f).method_39415(color.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
        DrawUtility.drawEnd();
        RenderSystem.setShaderTexture((int)0, (int)0);
        matrices.method_22909();
    }

    public static void drawShadow(class_4587 matrices, float x, float y, float width, float height, float softness, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        Batching batching = Batching.getActive();
        if (batching instanceof IconBatching) {
            IconBatching batching2 = (IconBatching)batching;
            class_287 builder = batching2.getBuilder();
            float horizontalPadding = -softness / 2.0f + softness * 2.0f;
            float verticalPadding = softness / 2.0f + softness;
            float adjustedX = x - horizontalPadding / 2.0f;
            float adjustedY = y - verticalPadding / 2.0f;
            float adjustedWidth = width + horizontalPadding;
            float adjustedHeight = height + verticalPadding;
            builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_39415(color.getRGB());
        } else {
            rectangleProgram.use();
            rectangleProgram.findUniform("Size").method_1255(width, height);
            rectangleProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius() * 3.0f, borderRadius.bottomLeftRadius() * 3.0f, borderRadius.topRightRadius() * 3.0f, borderRadius.bottomRightRadius() * 3.0f);
            rectangleProgram.findUniform("Smoothness").method_1251(softness);
            DrawUtility.drawSetup();
            float horizontalPadding = -softness / 2.0f + softness * 2.0f;
            float verticalPadding = softness / 2.0f + softness;
            float adjustedX = x - horizontalPadding / 2.0f;
            float adjustedY = y - verticalPadding / 2.0f;
            float adjustedWidth = width + horizontalPadding;
            float adjustedHeight = height + verticalPadding;
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            matrices.method_22909();
        }
    }

    public static void drawBlur(class_4587 matrices, float x, float y, float width, float height, float blurRadius, float squirt, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float smoothness = 0.03f;
        if (!((blurRadius /= 22.5f) <= 0.0f)) {
            blurProgram.setBlurOffset(2.0f);
            squircleTextureProgram.use();
            RenderSystem.setShaderTexture((int)0, (int)BlurProgram.getTexture());
            squircleTextureProgram.findUniform("Size").method_1255(width, height);
            squircleTextureProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius() * squirt / 2.0f, borderRadius.bottomLeftRadius() * squirt / 2.0f, borderRadius.topRightRadius() * squirt / 2.0f, borderRadius.bottomRightRadius() * squirt / 2.0f);
            squircleTextureProgram.findUniform("Smoothness").method_1251(0.1f);
            squircleTextureProgram.findUniform("CornerSmoothness").method_1251(squirt);
            DrawUtility.drawSetup();
            float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
            float verticalPadding = smoothness / 2.0f + smoothness;
            float adjustedX = x - horizontalPadding / 2.0f;
            float adjustedY = y - verticalPadding / 2.0f;
            float adjustedWidth = width + horizontalPadding;
            float adjustedHeight = height + verticalPadding;
            int screenWidth = mc.method_22683().method_4486();
            int screenHeight = mc.method_22683().method_4502();
            float u = adjustedX / (float)screenWidth;
            float v = ((float)screenHeight - adjustedY - adjustedHeight) / (float)screenHeight;
            float texWidth = adjustedWidth / (float)screenWidth;
            float texHeight = adjustedHeight / (float)screenHeight;
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_22913(u, v + texHeight).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_22913(u, v).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_22913(u + texWidth, v).method_39415(color.getRGB());
            builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_22913(u + texWidth, v + texHeight).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            RenderSystem.setShaderTexture((int)0, (int)0);
            matrices.method_22909();
        }
    }

    public static void drawBlur(class_4587 matrices, float x, float y, float width, float height, float blurRadius, BorderRadius borderRadius, ColorRGBA color) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        if (!((blurRadius /= 22.5f) <= 0.0f)) {
            blurProgram.setBlurOffset(2.0f);
            roundedTextureProgram.use();
            RenderSystem.setShaderTexture((int)0, (int)BlurProgram.getTexture());
            roundedTextureProgram.findUniform("Size").method_1255(width, height);
            roundedTextureProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
            roundedTextureProgram.findUniform("Smoothness").method_1251(0.01f);
            DrawUtility.drawSetup();
            int screenWidth = mc.method_22683().method_4486();
            int screenHeight = mc.method_22683().method_4502();
            float u = x / (float)screenWidth;
            float v = ((float)screenHeight - y - height) / (float)screenHeight;
            float texWidth = width / (float)screenWidth;
            float texHeight = height / (float)screenHeight;
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            builder.method_22918(matrix4f, x, y, 0.0f).method_22913(u, v + texHeight).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x, y + height, 0.0f).method_22913(u, v).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x + width, y + height, 0.0f).method_22913(u + texWidth, v).method_39415(color.getRGB());
            builder.method_22918(matrix4f, x + width, y, 0.0f).method_22913(u + texWidth, v + texHeight).method_39415(color.getRGB());
            class_286.method_43433((class_9801)builder.method_60800());
            DrawUtility.drawEnd();
            RenderSystem.setShaderTexture((int)0, (int)0);
            matrices.method_22909();
        }
    }

    public static void drawImage(class_4587 matrices, class_287 builder, double x, double y, double z, double width, double height, ColorRGBA color) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        builder.method_22918(matrix, (float)x, (float)(y + height), (float)z).method_22913(0.0f, 1.0f).method_39415(color.getRGB());
        builder.method_22918(matrix, (float)(x + width), (float)(y + height), (float)z).method_22913(1.0f, 1.0f).method_39415(color.getRGB());
        builder.method_22918(matrix, (float)(x + width), (float)y, (float)z).method_22913(1.0f, 0.0f).method_39415(color.getRGB());
        builder.method_22918(matrix, (float)x, (float)y, (float)z).method_22913(0.0f, 0.0f).method_39415(color.getRGB());
    }

    public static void drawImage(class_4587 matrices, class_2960 identifier, double x, double y, double z, double width, double height, ColorRGBA color) {
        RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        Matrix4f matrix = matrices.method_23760().method_23761();
        builder.method_22918(matrix, (float)x, (float)(y + height), (float)z).method_22913(0.0f, 1.0f).method_39415(color.getRGB());
        builder.method_22918(matrix, (float)(x + width), (float)(y + height), (float)z).method_22913(1.0f, 1.0f).method_39415(color.getRGB());
        builder.method_22918(matrix, (float)(x + width), (float)y, (float)z).method_22913(1.0f, 0.0f).method_39415(color.getRGB());
        builder.method_22918(matrix, (float)x, (float)y, (float)z).method_22913(0.0f, 0.0f).method_39415(color.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
    }

    public static void drawPlayerHeadWithHat(class_4587 matrices, class_742 player, float x, float y, float size, BorderRadius borderRadius, ColorRGBA color) {
        class_2960 skinTexture = player.method_52814().comp_1626();
        DrawUtility.drawPlayerHeadWithRoundedShader(matrices, skinTexture, x, y, size, borderRadius, color);
        DrawUtility.drawPlayerHatLayerWithRoundedShader(matrices, skinTexture, x, y, size, borderRadius, color);
    }

    public static <T extends class_1309, S extends class_10042, M extends class_583<? super S>> void drawEntityHeadWithHat(class_4587 matrices, T entity, float x, float y, float size, BorderRadius borderRadius, ColorRGBA color) {
        class_897 renderer = mc.method_1561().method_3953(entity);
        if (renderer instanceof class_922) {
            class_922 renderer1 = (class_922)renderer;
            class_922 livingRenderer = (class_922)renderer;
            class_10042 state = (class_10042)livingRenderer.method_55269();
            class_2960 skinTexture = livingRenderer.method_3885(state);
            DrawUtility.drawPlayerHeadWithRoundedShader(matrices, skinTexture, x, y, size, borderRadius, color);
            DrawUtility.drawPlayerHatLayerWithRoundedShader(matrices, skinTexture, x, y, size, borderRadius, color);
        }
    }

    public static void drawPlayerHeadWithRoundedShader(class_4587 matrices, class_2960 skinTexture, float x, float y, float size, BorderRadius borderRadius, ColorRGBA color) {
        DrawUtility.drawRoundedTextureWithUV(matrices, skinTexture, x, y, size, size, borderRadius, color, 0.125f, 0.125f, 0.25f, 0.25f);
    }

    private static void drawPlayerHatLayerWithRoundedShader(class_4587 matrices, class_2960 skinTexture, float x, float y, float size, BorderRadius borderRadius, ColorRGBA color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        DrawUtility.drawRoundedTextureWithUV(matrices, skinTexture, x, y, size, size, borderRadius, color, 0.625f, 0.125f, 0.75f, 0.25f);
        RenderSystem.disableBlend();
    }

    public static void drawRoundedTextureWithUV(class_4587 matrices, class_2960 identifier, float x, float y, float width, float height, BorderRadius borderRadius, ColorRGBA color, float u1, float v1, float u2, float v2) {
        matrices.method_22903();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float smoothness = 0.5f;
        roundedTextureProgram.use();
        RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
        roundedTextureProgram.findUniform("Size").method_1255(width, height);
        roundedTextureProgram.findUniform("Radius").method_35657(borderRadius.topLeftRadius(), borderRadius.bottomLeftRadius(), borderRadius.topRightRadius(), borderRadius.bottomRightRadius());
        roundedTextureProgram.findUniform("Smoothness").method_1251(smoothness);
        DrawUtility.drawSetup();
        float horizontalPadding = -smoothness / 2.0f + smoothness * 2.0f;
        float verticalPadding = smoothness / 2.0f + smoothness;
        float adjustedX = x - horizontalPadding / 2.0f;
        float adjustedY = y - verticalPadding / 2.0f;
        float adjustedWidth = width + horizontalPadding;
        float adjustedHeight = height + verticalPadding;
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        builder.method_22918(matrix4f, adjustedX, adjustedY, 0.0f).method_22913(u1, v1).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX, adjustedY + adjustedHeight, 0.0f).method_22913(u1, v2).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY + adjustedHeight, 0.0f).method_22913(u2, v2).method_39415(color.getRGB());
        builder.method_22918(matrix4f, adjustedX + adjustedWidth, adjustedY, 0.0f).method_22913(u2, v1).method_39415(color.getRGB());
        class_286.method_43433((class_9801)builder.method_60800());
        DrawUtility.drawEnd();
        RenderSystem.setShaderTexture((int)0, (int)0);
        matrices.method_22909();
    }

    public static void drawSetup() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void drawEnd() {
        RenderSystem.disableBlend();
    }

    @Generated
    private DrawUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static GlProgram getSquircleProgram() {
        return squircleProgram;
    }

    static {
        buffer = new CustomRenderTarget(false);
    }

    record HeadUV(float u1, float v1, float uSize, float vSize) {
    }
}

